/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwhat.jnativehook.example;

import com.github.kwhat.jnativehook.GlobalScreen;
import com.github.kwhat.jnativehook.NativeHookException;
import com.github.kwhat.jnativehook.dispatcher.SwingDispatchService;
import com.github.kwhat.jnativehook.keyboard.NativeKeyEvent;
import com.github.kwhat.jnativehook.keyboard.NativeKeyListener;
import com.github.kwhat.jnativehook.mouse.NativeMouseEvent;
import com.github.kwhat.jnativehook.mouse.NativeMouseInputListener;
import com.github.kwhat.jnativehook.mouse.NativeMouseWheelEvent;
import com.github.kwhat.jnativehook.mouse.NativeMouseWheelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class NativeHookDemo
extends JFrame
implements ActionListener,
ItemListener,
NativeKeyListener,
NativeMouseInputListener,
NativeMouseWheelListener,
WindowListener {
    private static final long serialVersionUID = 1541183202160543102L;
    private final JMenu menuSubListeners;
    private final JMenuItem menuItemQuit;
    private final JMenuItem menuItemClear;
    private final JCheckBoxMenuItem menuItemEnable;
    private final JCheckBoxMenuItem menuItemKeyboardEvents;
    private final JCheckBoxMenuItem menuItemButtonEvents;
    private final JCheckBoxMenuItem menuItemMotionEvents;
    private final JCheckBoxMenuItem menuItemWheelEvents;
    private final JTextArea txtEventInfo;
    private static final Logger log = Logger.getLogger(GlobalScreen.class.getPackage().getName());

    public NativeHookDemo() {
        this.setTitle("JNativeHook Demo");
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.setSize(600, 300);
        this.addWindowListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        menuFile.setMnemonic(70);
        menuBar.add(menuFile);
        this.menuItemQuit = new JMenuItem("Quit", 81);
        this.menuItemQuit.addActionListener(this);
        this.menuItemQuit.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        this.menuItemQuit.getAccessibleContext().setAccessibleDescription("Exit the program");
        menuFile.add(this.menuItemQuit);
        JMenu menuView = new JMenu("View");
        menuView.setMnemonic(86);
        menuBar.add(menuView);
        this.menuItemClear = new JMenuItem("Clear", 67);
        this.menuItemClear.addActionListener(this);
        this.menuItemClear.setAccelerator(KeyStroke.getKeyStroke(67, 192));
        this.menuItemClear.getAccessibleContext().setAccessibleDescription("Clear the screen");
        menuView.add(this.menuItemClear);
        menuView.addSeparator();
        this.menuItemEnable = new JCheckBoxMenuItem("Enable Native Hook");
        this.menuItemEnable.addItemListener(this);
        this.menuItemEnable.setMnemonic(72);
        this.menuItemEnable.setAccelerator(KeyStroke.getKeyStroke(72, 192));
        menuView.add(this.menuItemEnable);
        this.menuSubListeners = new JMenu("Listeners");
        this.menuSubListeners.setMnemonic(76);
        menuView.add(this.menuSubListeners);
        this.menuItemKeyboardEvents = new JCheckBoxMenuItem("Keyboard Events");
        this.menuItemKeyboardEvents.addItemListener(this);
        this.menuItemKeyboardEvents.setMnemonic(75);
        this.menuItemKeyboardEvents.setAccelerator(KeyStroke.getKeyStroke(75, 192));
        this.menuSubListeners.add(this.menuItemKeyboardEvents);
        this.menuItemButtonEvents = new JCheckBoxMenuItem("Button Events");
        this.menuItemButtonEvents.addItemListener(this);
        this.menuItemButtonEvents.setMnemonic(66);
        this.menuItemButtonEvents.setAccelerator(KeyStroke.getKeyStroke(66, 192));
        this.menuSubListeners.add(this.menuItemButtonEvents);
        this.menuItemMotionEvents = new JCheckBoxMenuItem("Motion Events");
        this.menuItemMotionEvents.addItemListener(this);
        this.menuItemMotionEvents.setMnemonic(77);
        this.menuItemMotionEvents.setAccelerator(KeyStroke.getKeyStroke(77, 192));
        this.menuSubListeners.add(this.menuItemMotionEvents);
        this.menuItemWheelEvents = new JCheckBoxMenuItem("Wheel Events");
        this.menuItemWheelEvents.addItemListener(this);
        this.menuItemWheelEvents.setMnemonic(87);
        this.menuItemWheelEvents.setAccelerator(KeyStroke.getKeyStroke(87, 192));
        this.menuSubListeners.add(this.menuItemWheelEvents);
        this.setJMenuBar(menuBar);
        this.txtEventInfo = new JTextArea();
        this.txtEventInfo.setEditable(false);
        this.txtEventInfo.setBackground(new Color(255, 255, 255));
        this.txtEventInfo.setForeground(new Color(0, 0, 0));
        this.txtEventInfo.setText("");
        JScrollPane scrollPane = new JScrollPane(this.txtEventInfo);
        scrollPane.setPreferredSize(new Dimension(375, 125));
        this.add((Component)scrollPane, "Center");
        log.setUseParentHandlers(false);
        log.setLevel(Level.INFO);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        log.addHandler(handler);
        GlobalScreen.setEventDispatcher(new SwingDispatchService());
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuItemQuit) {
            this.dispose();
        } else if (e.getSource() == this.menuItemClear) {
            this.txtEventInfo.setText("");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable item = e.getItemSelectable();
        if (item == this.menuItemEnable) {
            try {
                if (e.getStateChange() == 1) {
                    GlobalScreen.registerNativeHook();
                } else {
                    GlobalScreen.unregisterNativeHook();
                }
            }
            catch (NativeHookException ex) {
                this.txtEventInfo.append("Error: " + ex.getMessage() + "\n");
            }
            this.menuItemEnable.setState(GlobalScreen.isNativeHookRegistered());
            this.menuSubListeners.setEnabled(this.menuItemEnable.getState());
        } else if (item == this.menuItemKeyboardEvents) {
            if (e.getStateChange() == 1) {
                GlobalScreen.addNativeKeyListener(this);
            } else {
                GlobalScreen.removeNativeKeyListener(this);
            }
        } else if (item == this.menuItemButtonEvents) {
            if (e.getStateChange() == 1) {
                GlobalScreen.addNativeMouseListener(this);
            } else {
                GlobalScreen.removeNativeMouseListener(this);
            }
        } else if (item == this.menuItemMotionEvents) {
            if (e.getStateChange() == 1) {
                GlobalScreen.addNativeMouseMotionListener(this);
            } else {
                GlobalScreen.removeNativeMouseMotionListener(this);
            }
        } else if (item == this.menuItemWheelEvents) {
            if (e.getStateChange() == 1) {
                GlobalScreen.addNativeMouseWheelListener(this);
            } else {
                GlobalScreen.removeNativeMouseWheelListener(this);
            }
        }
    }

    public void nativeKeyPressed(NativeKeyEvent e) {
        this.appendDisplay(e.paramString());
    }

    public void nativeKeyReleased(NativeKeyEvent e) {
        this.appendDisplay(e.paramString());
    }

    public void nativeKeyTyped(NativeKeyEvent e) {
        this.appendDisplay(e.paramString());
    }

    public void nativeMouseClicked(NativeMouseEvent e) {
        this.appendDisplay(e.paramString());
    }

    public void nativeMousePressed(NativeMouseEvent e) {
        this.appendDisplay(e.paramString());
    }

    public void nativeMouseReleased(NativeMouseEvent e) {
        this.appendDisplay(e.paramString());
    }

    public void nativeMouseMoved(NativeMouseEvent e) {
        this.appendDisplay(e.paramString());
    }

    public void nativeMouseDragged(NativeMouseEvent e) {
        this.appendDisplay(e.paramString());
    }

    @Override
    public void nativeMouseWheelMoved(NativeMouseWheelEvent e) {
        this.appendDisplay(e.paramString());
    }

    private void appendDisplay(String output) {
        this.txtEventInfo.append("\n" + output);
        try {
            if (this.txtEventInfo.getLineCount() > 100) {
                this.txtEventInfo.replaceRange("", 0, this.txtEventInfo.getLineEndOffset(this.txtEventInfo.getLineCount() - 1 - 100));
            }
            this.txtEventInfo.setCaretPosition(this.txtEventInfo.getLineStartOffset(this.txtEventInfo.getLineCount() - 1));
        }
        catch (BadLocationException ex) {
            this.txtEventInfo.setCaretPosition(this.txtEventInfo.getDocument().getLength());
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.requestFocusInWindow();
        this.txtEventInfo.setText("Auto Repeat Rate: " + System.getProperty("jnativehook.key.repeat.rate"));
        this.appendDisplay("Auto Repeat Delay: " + System.getProperty("jnativehook.key.repeat.delay"));
        this.appendDisplay("Double Click Time: " + System.getProperty("jnativehook.button.multiclick.iterval"));
        this.appendDisplay("Pointer Sensitivity: " + System.getProperty("jnativehook.pointer.sensitivity"));
        this.appendDisplay("Pointer Acceleration Multiplier: " + System.getProperty("jnativehook.pointer.acceleration.multiplier"));
        this.appendDisplay("Pointer Acceleration Threshold: " + System.getProperty("jnativehook.pointer.acceleration.threshold"));
        this.menuItemEnable.setSelected(true);
        try {
            this.txtEventInfo.setCaretPosition(this.txtEventInfo.getLineStartOffset(this.txtEventInfo.getLineCount() - 1));
        }
        catch (BadLocationException ex) {
            this.txtEventInfo.setCaretPosition(this.txtEventInfo.getDocument().getLength());
        }
        this.menuItemKeyboardEvents.setSelected(true);
        this.menuItemButtonEvents.setSelected(true);
        this.menuItemMotionEvents.setSelected(true);
        this.menuItemWheelEvents.setSelected(true);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        try {
            GlobalScreen.unregisterNativeHook();
        }
        catch (NativeHookException ex) {
            ex.printStackTrace();
        }
        System.runFinalization();
        System.exit(0);
    }

    public static void main(String[] args) {
        String copyright = "\nJNativeHook: Global keyboard and mouse listeners for Java.\nCopyright (C) 2006-2021 Alexander Barker.  All Rights Reserved.\nhttps://github.com/kwhat/jnativehook/\n\nJNativeHook is free software: you can redistribute it and/or modify\nit under the terms of the GNU Lesser General Public License as published\nby the Free Software Foundation, either version 3 of the License, or\n(at your option) any later version.\n\nJNativeHook is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU Lesser General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.\n";
        System.out.println(copyright);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new NativeHookDemo();
            }
        });
    }
}

