/*
 * Decompiled with CFR 0.152.
 */
package com.github.joonasvali.naturalmouse.support;

import com.github.joonasvali.naturalmouse.api.OvershootManager;
import com.github.joonasvali.naturalmouse.support.Flow;
import java.awt.Point;
import java.util.Random;

public class DefaultOvershootManager
implements OvershootManager {
    public static final double OVERSHOOT_SPEEDUP_DIVIDER = 1.8;
    public static final int MIN_OVERSHOOT_MOVEMENT_MS = 40;
    public static final int OVERSHOOT_RANDOM_MODIFIER_DIVIDER = 20;
    public static final int MIN_DISTANCE_FOR_OVERSHOOTS = 10;
    public static final int DEFAULT_OVERSHOOT_AMOUNT = 3;
    private long minOvershootMovementMs = 40L;
    private long minDistanceForOvershoots = 10L;
    private double overshootRandomModifierDivider = 20.0;
    private double overshootSpeedupDivider = 1.8;
    private int overshoots = 3;
    private final Random random;

    public DefaultOvershootManager(Random random) {
        this.random = random;
    }

    @Override
    public int getOvershoots(Flow flow, long mouseMovementMs, double distance) {
        if (distance < (double)this.minDistanceForOvershoots) {
            return 0;
        }
        return this.overshoots;
    }

    @Override
    public Point getOvershootAmount(double distanceToRealTargetX, double distanceToRealTargetY, long mouseMovementMs, int overshootsRemaining) {
        double distanceToRealTarget = Math.hypot(distanceToRealTargetX, distanceToRealTargetY);
        double randomModifier = distanceToRealTarget / this.overshootRandomModifierDivider;
        int x = (int)(this.random.nextDouble() * randomModifier - randomModifier / 2.0) * overshootsRemaining;
        int y = (int)(this.random.nextDouble() * randomModifier - randomModifier / 2.0) * overshootsRemaining;
        return new Point(x, y);
    }

    @Override
    public long deriveNextMouseMovementTimeMs(long mouseMovementMs, int overshootsRemaining) {
        return Math.max((long)((double)mouseMovementMs / this.overshootSpeedupDivider), this.minOvershootMovementMs);
    }

    public long getMinOvershootMovementMs() {
        return this.minOvershootMovementMs;
    }

    public void setMinOvershootMovementMs(long minOvershootMovementMs) {
        this.minOvershootMovementMs = minOvershootMovementMs;
    }

    public double getOvershootRandomModifierDivider() {
        return this.overshootRandomModifierDivider;
    }

    public void setOvershootRandomModifierDivider(double overshootRandomModifierDivider) {
        this.overshootRandomModifierDivider = overshootRandomModifierDivider;
    }

    public double getOvershootSpeedupDivider() {
        return this.overshootSpeedupDivider;
    }

    public void setOvershootSpeedupDivider(double overshootSpeedupDivider) {
        this.overshootSpeedupDivider = overshootSpeedupDivider;
    }

    public int getOvershoots() {
        return this.overshoots;
    }

    public void setOvershoots(int overshoots) {
        this.overshoots = overshoots;
    }

    public long getMinDistanceForOvershoots() {
        return this.minDistanceForOvershoots;
    }

    public void setMinDistanceForOvershoots(long minDistanceForOvershoots) {
        this.minDistanceForOvershoots = minDistanceForOvershoots;
    }
}

